
import flixel.util.FlxColor;
import flixel.text.FlxText;
import flixel.text.FlxTextBorderStyle;
import flixel.text.FlxTextAlign;
import funkin.game.PlayState;
import flixel.tweens.FlxTween;
import flixel.tweens.FlxEase;
// import Apology;

var text:FlxText;

function postCreate()
{

	text = new FlxText(0, 0, 0, "oewrhin", 12);
	text.setFormat(Paths.font('micross.ttf'), 85);

	text.cameras = [camHUD2];
	text.alignment = FlxTextAlign.CENTER;
	text.antialiasing = true;
	text.borderStyle = FlxTextBorderStyle.SHADOW;
	text.borderSize = 2.5;
	text.borderColor = 0x7D000000;

	text.updateHitbox();

	text.scale.set(0.001, 0.001);
	text.alpha = 0.001;
	add(text);
}

function onEvent(__event)
{
	if (__event.event.name == "Titlecard") {
	
		text.text = __event.event.params[0] + '\n(' + "by " + __event.event.params[1] + ')';
		text.screenCenter();
	
		text.angle = 360 * 4;

		FlxTween.tween(text, {
			angle: 0,
			alpha: 1,
			"scale.x": 0.8,
			"scale.y": 0.8
		}, 1.25, {ease: FlxEase.linear, onComplete: postSPEEEEEEEEEEEEN});
	}
}

import flixel.util.FlxTimer;

function postSPEEEEEEEEEEEEN()
{
	new FlxTimer().start(2, () ->
	{
		FlxTween.tween(text, {
			alpha: 0
		}, 1, {
			ease: FlxEase.linear,
			onComplete: function()
			{
				text.destroy();
				remove(text);
			}
		});
	});
}